typedef	char TextureName[12];

struct VRLVertexHeader 
{
	unsigned long VertexCount;
	unsigned long VertexsOffset;
	unsigned long TransformedVerexOffset;
	unsigned long VertexIntensitysOffset;
	unsigned long VertexAIntensitysOffset;
	unsigned long VertexBIntensitysOffset;
	unsigned long FirstGNormalsOffset;
	unsigned long GNormalIndexCountOffset;
	unsigned long GNormalIndexesOffset;
};


struct VRLPointHeader
{
	unsigned long PointCount;
	unsigned long PointsOffset;
	unsigned long TUPointsOffset;
	unsigned long TVPointsOffset;
};

struct VRLNormalHeader
{
	unsigned long NormalCount;
	unsigned long NormalsOffset;
};

struct VRLPolygonHeader
{
	unsigned long PolygonCount;
	unsigned long PointCountsOffset;
	unsigned long FirstPointsOffset;
	unsigned long NormalIndexesOffset;
	unsigned long DPlanesOffset;
	unsigned long FlagsOffset;
	unsigned long ColorsOffset;
	unsigned long MIPLevelsOffset;
	unsigned long TypesOffset;
	unsigned long TexIndexesOffset;
};

struct VRLTextureMapHeader
{
	unsigned long TextureMapCount;
	unsigned long TextureMapsOffset;
};


struct VRLHeader
{
	char m_Blank[60];
	VRLVertexHeader VertexHeader;
	VRLPointHeader PointHeader;
	VRLNormalHeader NormalHeader;
	VRLPolygonHeader PolygonHeader;
	VRLTextureMapHeader TextureMapHeader;
	unsigned long NextObjectOffset;
};

struct VRLVertex
{
	float X;
	float Y;
	float Z;
	long Updated;
};

struct VRLPoint
{
	long	*VertIndexes;
	float	*Us, *Vs;
};

struct VRLColor
{
	BYTE R;
	BYTE G;
	BYTE B;
	BYTE Alpha;
};

//======================================================================
//					F1 2000
//======================================================================
struct fVRLDefsHeader
{
	float	MinBox[3];
	float	MaxBox[3];
	float	Radius;
	float	LOD[3];
	float	SwitchIn;

	long	SwitchMid;
	long	SwitchOut;
	float	ZOffset;
	long	nFlags;
};

struct fVRLVertexHeader 
{
	unsigned long VertexCount;
	unsigned long VertexsOffset;
	unsigned long TransformedVerexOffset;
	unsigned long GNormalsOffset;
	unsigned long XNormalsOffset;
	unsigned long VertexIntensitysOffset;
	unsigned long VertexAIntensitysOffset;
	unsigned long VertexBIntensitysOffset;
};


struct fVRLPointHeader
{
	unsigned long PointCount;
	unsigned long PointsOffset;
	unsigned long TUPointsOffset;
	unsigned long TVPointsOffset;
	unsigned long TSPointsOffset;
	unsigned long TTPointsOffset;
};

struct fVRLNormalHeader
{
	unsigned long NormalCount;
	unsigned long NormalsOffset;
};

struct fVRLPolygonHeader
{
	unsigned long PolygonCount;
	unsigned long PointCountsOffset;
	unsigned long FirstPointsOffset;
	unsigned long NormalIndexesOffset;
	unsigned long DPlanesOffset;
	unsigned long FlagsOffset;
	unsigned long ColorsOffset;
	unsigned long MIPLevelsOffset;
	unsigned long TypesOffset;
	unsigned long TexIndexesOffset;
	unsigned long XMin, XMax, YMin, YMax, ZMin, ZMax;
};

struct fVRLTextureMapHeader
{
	unsigned long TextureMapCount;
	unsigned long TextureMapsOffset;
};


struct fVRLHeader
{
	fVRLDefsHeader			DefsHeader;
	fVRLVertexHeader		VertexHeader;
	fVRLPointHeader			PointHeader;
	fVRLNormalHeader		NormalHeader;
	fVRLPolygonHeader		PolygonHeader;
	fVRLTextureMapHeader	TextureMapHeader;
	unsigned long			NextObjectOffset;
};
